/* FILE: mlexer.h                               (D. Tottingham  12/26/90)

This is an include file of defines, data structure definitions and
external declarations that are common in the mlexer module.

*/

#ifndef _MLEXER_
#define _MLEXER_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define MAXLEX                  80
#define COMMENT_CHAR            '#'

#define C_CHARACTER             301
#define C_CONSTANT              302
#define C_DONE                  303
#define C_ID                    304
#define C_STRING                305

#define C_AUTHORITY             306
#define C_AUTO_LOCATION         307
#define C_AUTO_LOG              308
#define C_AUTO_REBOOT           309
#define C_AUTO_TRIGGER          310
#define C_BAND_LIMITS           311
#define C_BAND_RECORDING        312
#define C_BUFFERS_TO_AVERAGE    313
#define C_CALIBRATION_RECORDING 314
#define C_CH                    315
#define C_CHANNEL_BLOCKSIZE     316
#define C_CHANNEL_GAIN          317
#define C_CLOCK_SOURCE          318
#define C_COMPONENT             319
#define C_CRITICAL_ALPHA        320
#define C_CRITICAL_BETA         321
#define C_CRITICAL_GAMMA        322
#define C_CRITICAL_MU           323
#define C_CRITICAL_NU           324
#define C_CRITICAL_PHI          325
#define C_DIGITIZATION_RATE     326
#define C_DISPLAY               327
#define C_EVENT_ALERT_BELL      328
#define C_EVENT_CONTINUE_COUNT  329
#define C_EXTERNAL              330
#define C_FALSE                 331
#define C_FREERUN_BLOCK_TIME    332
#define C_GAIN                  333
#define C_HALFSPACE_VELOCITY    334
#define C_INTERNAL              335
#define C_LOG_PATHNAME          336
#define C_LTA_WINDOW            337
#define C_MAX_CALIBRATION_TIME  338
#define C_MAX_EVENT_TIME        339
#define C_MIN_EVENT_TIME        340
#define C_NETWORK               341
#define C_NETWORK_NODE_ID       342
#define C_OFF                   343
#define C_ON                    344
#define C_PATHNAME              345
#define C_PRE_EVENT_TIME        346
#define C_STA_WINDOW            347
#define C_STNAME                348
#define C_TIME                  349
#define C_TRIGGER               350
#define C_TRIGGER_CONFIRM_COUNT 351
#define C_TRIGGER_SOURCE        352
#define C_TRIGGER_TIME_LIMIT    353
#define C_TRUE                  354


/************************************************************************
                          STRUCTURE DEFINITIONS


************************************************************************/
typedef struct {
        char *name;
        int token;
} LX_KEYWORD;

typedef struct {
        int lookahead;
        int lineno;
        int error;
        char lexeme[MAXLEX];
} LX_INFO;


/*************************************************************************
                              GLOBAL DATA

**************************************************************************/
PUBLIC LX_INFO lex_info;


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC void lx_initialize ();
PUBLIC void lx_match (int);
PUBLIC void lx_set_stream (FILE *);

#endif
